float4x4 World;
float4x4 View;
float4x4 Projection;

float3 Light0;
float4 LightColor0;
float4 AmbientColor;

float3 CameraPosition;

// TODO: add effect parameters here.

struct VertexShaderInput
{
    float3 Position : POSITION0;
    float3 Normal : NORMAL0;
    float4 Diffuse : COLOR0;
    float4 Specular : COLOR1;
    //float Shiney : BLENDWEIGHT0; // shiney coefficient

    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;
    float3 WorldPosition : POSITION1;
    float3 Normal : NORMAL0;
    float4 Diffuse : COLOR0;
    float4 Specular : COLOR1;
    float Shiney : BLENDWEIGHT0;

    // TODO: add vertex shader outputs such as colors and texture
    // coordinates here. These values will automatically be interpolated
    // over the triangle, and provided as input to your pixel shader.
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output;

	float4 Position;
	Position.xyz = input.Position;
	Position.w = 1;
	
	float4 worldPosition = mul(Position, World);
    float4 viewPosition = mul(worldPosition, View);
    
    output.Position = mul(viewPosition, Projection);
    output.WorldPosition = worldPosition.xyz;
    output.Normal = input.Normal;
    output.Diffuse = input.Diffuse;
    output.Specular = input.Specular;
    output.Shiney = 150.f; // for now

    // TODO: add your vertex shader code here.

    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{
	float4 Ambient = AmbientColor * input.Diffuse;

	// normalize the normal
	float3 Normal = normalize(input.Normal);
	// rotate the normal (only works if world does not perform any scaling)
	Normal = mul(Normal, World);

	// get the vector to the light
    float4 vLight;
    vLight.xyz = Light0;
    //vLight.xyz = normalize(Light0 - input.WorldPosition);
    vLight.w = 0;
    
    // calculate diffuse
    float dotp = (dot(vLight,Normal));
    dotp = (dotp<0)?0:dotp;
    //dotp = abs(dotp);
    
    float4 Diffuse = dotp * input.Diffuse * LightColor0;
    
    // Get the vector to the camera
    float4 vCam;
    vCam.xyz = CameraPosition - input.WorldPosition;
    vCam.xyz = normalize(vCam.xyz);
    vCam.w = 0;
    
    // calculate H
    float3 H;
    H = vLight.xyz + vCam.xyz;
    H = normalize(H);
    
    // calculate the specular component of the color
    dotp = dot( Normal, H );
    dotp = (dotp<0)?0:dotp;
    //dotp = abs(dotp);
    dotp = pow( dotp, input.Shiney );
    
    float4 Specular = input.Specular * dotp;

    return Diffuse + Ambient + Specular;
}

technique Phong
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_3_0 VertexShaderFunction();
        PixelShader = compile ps_3_0 PixelShaderFunction();
    }
}
